/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;

public class ItemMusicSheet
extends class_1792 {
    private static final HashMap<IItemInstrument.Pair<String, String>, UUID> convertMap = new HashMap();
    private static final int addToOldEnd = 8;

    ItemMusicSheet() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static ArrayList<NoteEvent> oldMusicToNotes(byte[] music) {
        ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
        for (int i = 0; i < music.length; ++i) {
            if (music[i] <= 0) continue;
            int nextTime = -1;
            for (int j = i + 1; j < music.length; ++j) {
                if (music[j] <= 0) continue;
                nextTime = j;
                break;
            }
            int l = 1;
            if (nextTime > i && nextTime - i < 20) {
                l = nextTime - i;
            } else if (i == music.length - 1) {
                l = 8;
            }
            byte note = (byte)(music[i] + 32);
            notes.add(new NoteEvent(note, (short)i, 64, (byte)l));
        }
        return notes;
    }

    public static ArrayList<NoteEvent> convertFromOld(class_2487 nbt, MinecraftServer server) {
        UUID id;
        int length = nbt.method_10550("length");
        byte pause = nbt.method_10571("pause");
        byte[] music = nbt.method_10547("music");
        byte bps = (byte)Math.round(20.0f / (float)pause);
        ArrayList<NoteEvent> notes = ItemMusicSheet.oldMusicToNotes(music);
        nbt.method_10569("l", length + 8);
        nbt.method_10567("bps", bps);
        if (nbt.method_10545("author") && nbt.method_10545("title")) {
            String title;
            String author = nbt.method_10558("author");
            IItemInstrument.Pair<String, String> key = new IItemInstrument.Pair<String, String>(author, title = nbt.method_10558("title"));
            if (convertMap.containsKey(key)) {
                id = convertMap.get(key);
            } else {
                id = UUID.randomUUID();
                convertMap.put(key, id);
                MusicManager.setMusicData(id, 1, notes, server);
            }
        } else {
            id = UUID.randomUUID();
            MusicManager.setMusicData(id, 1, notes, server);
        }
        nbt.method_25927("id", id);
        nbt.method_10569("ver", 1);
        nbt.method_10551("length");
        nbt.method_10551("pause");
        nbt.method_10551("music");
        return notes;
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, @Nonnull class_1268 hand) {
        class_1799 heldItem = playerIn.method_5998(hand);
        if (worldIn.field_9236) {
            playerIn.method_5783(SoundEvents.OPEN_SCROLL, 1.0f, 0.8f + worldIn.field_9229.method_43057() * 0.4f);
            Mod.onlyRunOnClient(() -> ClientStuff::showMusicGui);
        }
        return new class_1271(class_1269.field_5812, (Object)heldItem);
    }

    @Nonnull
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        String title = (String)stack.method_57824(Items.SHEET_TITLE);
        if (title != null) {
            return class_2561.method_43470((String)title);
        }
        return super.method_7864(stack);
    }

    public static byte getBPS(@Nonnull class_1799 stack) {
        return (Byte)stack.method_57825(Items.SHEET_BPS, (Object)0);
    }

    public static int getPrevInstrument(@Nonnull class_1799 stack) {
        Byte prevIns = (Byte)stack.method_57824(Items.SHEET_PREV_INSTRUMENT);
        if (prevIns != null) {
            return prevIns.byteValue();
        }
        return -1;
    }

    public static float getVolume(@Nonnull class_1799 stack) {
        return ((Float)stack.method_57825(Items.SHEET_VOLUME, (Object)Float.valueOf(1.0f))).floatValue();
    }

    public static boolean isEmptySheet(@Nonnull class_1799 stack) {
        return stack.method_57824(Items.SHEET_GENERATION) == null && stack.method_57824(Items.SHEET_ID) == null && stack.method_57824(Items.SHEET_VERSION) == null;
    }

    public void method_7851(@NotNull class_1799 stack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 tooltipFlag) {
        int prevIns;
        byte bps;
        int length;
        int generation;
        String s = (String)stack.method_57824(Items.SHEET_AUTHOR);
        if (s != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"note.byAuthor", (Object[])new Object[]{s}));
        }
        if ((generation = ((Integer)stack.method_57825(Items.SHEET_GENERATION, (Object)0)).intValue()) > 0) {
            tooltip.add((class_2561)class_2561.method_43471((String)("note.generation." + (generation - 1))).method_27692(generation == 1 ? class_124.field_1065 : class_124.field_1080));
        }
        if ((length = ((Integer)stack.method_57825(Items.SHEET_LENGTH, (Object)0)).intValue()) > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"note.length", (Object[])new Object[]{length}).method_27692(class_124.field_1080));
        }
        if ((bps = ItemMusicSheet.getBPS(stack)) > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"note.tempo", (Object[])new Object[]{bps * 60}).method_27692(class_124.field_1080));
        }
        if ((prevIns = ItemMusicSheet.getPrevInstrument(stack)) >= 0 && prevIns < Items.instruments.length) {
            class_2561 name = ((class_1792)Items.instruments[prevIns]).method_7864(new class_1799((class_1935)((class_1792)Items.instruments[prevIns])));
            tooltip.add((class_2561)class_2561.method_43469((String)"note.preview_instrument", (Object[])new Object[]{name}).method_27692(class_124.field_1080));
        }
    }

    @Nonnull
    public class_1269 method_7884(class_1838 context) {
        class_2338 blockpos;
        class_1937 world = context.method_8045();
        class_2680 blockState = world.method_8320(blockpos = context.method_8037());
        if (blockState.method_26204() == Blocks.MUSIC_BOX && !((Boolean)blockState.method_11654((class_2769)BlockMusicBox.HAS_MUSIC)).booleanValue()) {
            class_1799 itemstack = context.method_8041();
            if (!world.field_9236 && itemstack.method_57824(Items.SHEET_ID) != null) {
                BlockMusicBox.insertMusic((class_1936)world, blockpos, blockState, itemstack.method_7972());
                if (context.method_8036() != null && !context.method_8036().method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_7886(class_1799 stack) {
        return (Integer)stack.method_57825(Items.SHEET_GENERATION, (Object)0) > 0;
    }
}

